<x-kasir.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">

            </div><!-- /.container-fluid -->
        </div>

        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <x-message></x-message>
                        <div class="card card-danger card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><i class="fa fa-server text-danger"></i> {{ $data['page'] }}</h3>
                                <form class="form-inline float-right">
                                    <input class="form-control mr-sm-2" type="search" placeholder="Search"
                                        aria-label="Search" name="cari">
                                    <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                        Cari!</button>
                                </form>
                            </div>
                            <div class="card-body">
                                <button class="btn btn-default shadow-sm">
                                    <div class="icheck-blue d-inline " style="margin-right: -7px">
                                        <input type="checkbox" id="cekall">
                                        <label for="cekall">
                                        </label>
                                    </div>
                                </button>
                                {{-- <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i>
                                    Hapus</button> --}}
                                <button class="btn btn-dark" id="cetak_kartu"><i class="fa fa-print"></i> Cetak
                                    Kartu</button>


                                <a href="/member-tambah" class="btn btn-success float-right mb-3"><i
                                        class="fa fa-plus-circle mr-2"></i> Member
                                    Baru</a>



                                <table class="table table-bordered table-hover myTable tab">
                                    <thead>
                                        <tr>
                                            <th width="5%">No</th>
                                            <th>#</th>
                                            <th>Kode Member</th>
                                            <th>Nama Member</th>
                                            <th>Hp</th>
                                            <th>Email</th>
                                            <th>Jns. Kelamin</th>
                                            <th>Username</th>
                                            <th>Jml. Poin</th>
                                            <th>Tukar Poin</th>
                                            <th>Tgl. Input</th>
                                            <th>Opsi</th>
                                        </tr>
                                    </thead>
                                    <tbody id="view">
                                        @forelse ($member as $m)
                                            @if ($m->kd_member == '0')
                                            @else
                                                <tr>
                                                    <td class="text-center"> {{ $no++ }}</td>
                                                    <td class="text-center">
                                                        <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                            <input type="checkbox" name="id[]"
                                                                id="cek{{ $m->id }}" class="ceklis"
                                                                value="{{ $m->id }}">
                                                            <label for="cek{{ $m->id }}">
                                                            </label>
                                                        </div>
                                                    </td>
                                                    <td>{{ $m->kd_member }}</td>
                                                    <td>{{ $m->nm_member }}</td>
                                                    <td>{{ $m->hp_member }}</td>
                                                    <td>{{ $m->email_member }}</td>
                                                    <td>{{ $m->kelamin_member == 'L' ? 'Laki-Laki' : 'Perempuan' }}
                                                    </td>
                                                    <td>{{ $m->username }}</td>
                                                    <td class="text-center">
                                                        {{ poinmasuk($m->id) - poinkeluar($m->id) }}</td>
                                                    <td class="text-center">{{ poinkeluar($m->id) }}</td>
                                                    <td>{{ tgl_inf($m->created_at) }} </td>
                                                    <td class="text-center">
                                                        <div class="btn-group" role="group">
                                                            <button id="btnGroupDrop1" type="button"
                                                                class="btn btn-primary dropdown-toggle"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                <i class="fa fa-edit mr-3"></i>
                                                                Opsi
                                                            </button>
                                                            <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                                                                <a class="dropdown-item edit" href="#"
                                                                    data-id="{{ $m->id }}">Edit
                                                                    Data</a>
                                                                <a class="dropdown-item ongkir" href="#"
                                                                    data-id="{{ $m->id }}">Edit
                                                                    Ongkir</a>
                                                                <a class="dropdown-item password" href="#"
                                                                    data-id="{{ $m->id }}">Edit
                                                                    Password</a>
                                                                <a class="dropdown-item detail" href="#"
                                                                    data-id="{{ $m->id }}">Detail</a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endif
                                        @empty
                                            <tr>
                                                <td colspan="12" class="text-center text-danger"> Data
                                                    masih
                                                    kosong.
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>

                                {{ $member->links('components.admin.pagination') }}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->

                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
    </div>
    <!-- /.content -->


    <div id="hidedata">
        <div class="tampil_data" id="print"></div>
    </div>


    {{-- Edit Data --}}
    <div class="modal fade" id="editdata">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Edit data member
                </div>
                <div class="modal-body" id="vdata">
                    <input type="hidden" name="" id="idm">
                    <div class="form-graoup">
                        <label for="">Kode Member</label>
                        <input type="text" name="kode" id="kode" class="form-control" readonly>
                    </div>
                    <div class="form-graoup mt-2">
                        <label for="">Nama Member</label>
                        <input type="text" name="nama" id="nama" class="form-control">
                    </div>
                    <div class="form-graoup mt-2">
                        <label for="">Hp Member</label>
                        <input type="text" name="hp" id="hp" class="form-control">
                    </div>
                    <div class="form-graoup mt-2">
                        <label for="">Email Member</label>
                        <input type="text" name="email" id="email" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Jenis Kelamin</label>
                        <div class="row">

                            <div class="col-md-6">
                                <div class="custom-control custom-radio">
                                    <input class="custom-control-input jns" type="radio" id="laki"
                                        value="L" name="kelamin_member">
                                    <label for="laki" class="custom-control-label ">Laki-Laki
                                    </label>
                                </div>
                            </div>
                            <input type="hidden" name="" id="kelamin" value="L">
                            <div class="col-md-6">
                                <div class="custom-control custom-radio">
                                    <input class="custom-control-input jns" type="radio" id="perempuan"
                                        value="P" name="kelamin_member">
                                    <label for="perempuan" class="custom-control-label ">Perempuan
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-graoup mt-2">
                        <label for="">Username</label>
                        <input type="text" name="username" id="username" class="form-control">
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary float-right simpan_data"><i
                            class="fa fa-save mr-2"></i> Simpan
                        Perubahan</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- Edit Ongkir --}}
    <div class="modal fade" id="editongkir">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Edit Ongkir member
                </div>
                <div class="modal-body" id="vdataongkir">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- Edit Data --}}
    <div class="modal fade" id="editpass">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Edit Password member
                </div>
                <div class="modal-body" id="vdata">
                    <input type="hidden" name="" id="idmp">
                    <div class="form-graoup">
                        <label for="">Kode Member</label>
                        <input type="text" id="kodep" class="form-control" readonly>
                    </div>
                    <div class="form-graoup mt-2">
                        <label for="">Nama Member</label>
                        <input type="text" id="namap" class="form-control" readonly>
                    </div>

                    <div class="form-graoup mt-2">
                        <label for="">Password</label>
                        <input type="password" id="password" class="form-control" placeholder="Password baru!">
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary float-right simpan_password"><i
                            class="fa fa-save mr-2"></i> Simpan
                        Perubahan</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    {{-- detail member --}}
    <div class="modal fade" id="detail">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Detail member
                </div>
                <div class="modal-body" id="vdetail">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/member.js"></script>
    </x-slot:foot>
</x-kasir.contents>
